Attribute VB_Name = "Module1"
Option Explicit

'Costante x la conversione del Path DOS
Public Const SW_SHOWNORMAL As Long = 1

'*** Per convertire path lunghi in formato x DOS ***
Private Declare Function GetShortPathName Lib "kernel32" Alias _
    "GetShortPathNameA" (ByVal lpszLongPath As String, _
    ByVal lpszShortPath As String, ByVal cchBuffer As Long) As Long
'Const MAX_PATH = 260
'***************************************************

'Per aprire i file in automatico
Declare Function ShellExecute Lib "shell32.dll" _
Alias "ShellExecuteA" _
(ByVal hWnd As Long, ByVal lpOperation As String, _
ByVal lpFile As String, ByVal lpParameters As String, _
ByVal lpDirectory As String, ByVal nShowCmd As Long) As Long



Private Sub Main()
   Dim TimeStart As Date
   Dim TimeEnd As Date
   Dim PathFileExe As String
   Dim PathNewFileExe As String
   
   On Error GoTo gesterr
   
   'Cancello eventuali file di log dell'anno precedente in modo da non creare file spazzatura
      Call KillaFile(App.Path & "\Log\LogSincro_" & (Year(Date) - 1) & "." & Format(Date, "mm") & ".cnf")

   
   'Setto le variabili
      PathFileExe = App.Path & "\PatchUpdater.exe"
      PathNewFileExe = App.Path & "\PatchUpdaterNew.exe"
      
   'Verifico che ci sia il NUOVO file altrimenti non posso fare nulla e lancio chiudo l'applicazione
   If VerificaEsistenzaFile(PathNewFileExe) Then
      
      'Setto il tempo
         'TimeStart = Now()
         TimeEnd = DateAdd("s", 3, Now())
         
      'Eseguo una pausa di tre secondi
         Do Until Now() > TimeEnd
            DoEvents
         Loop
      
      'elimino il file "vecchio"
         Kill PathFileExe
      
      'e rinomino il file nuovo e lo eseguo
         Name PathNewFileExe As PathFileExe
   
      'eseguo il file PatchUpdater.exe
         Dim RetVal
         'RetVal = ShellExecute(0&, "Open", App.Path & "\Utility\GetAPP\PrimoGetAPP.exe", 0&, App.Path & "\Utility\GetAPP\", SW_SHOWNORMAL)
         RetVal = ShellExecute(0&, "Open", PathFileExe, 0&, GetPathFile(PathFileExe), SW_SHOWNORMAL)
      
      'Qui registro l'Aggiornamento avvenuto
         Call MsgInLogFile("Nuovo PatchUpdater impostato ed eseguito")
   End If
   
   
   

gesterr:
   If Err.Number = 53 Then
      Resume Next
   ElseIf Err.Number <> 0 Then
      Call MsgInLogFile(Err.Number & "-" & Err.Description)
   End If
   On Error GoTo 0
End Sub


Private Function VerificaEsistenzaFile(pPathFile As String) As Boolean
   Dim MyFile As String
            
   'restituisce una stringa vuota se la cartella non esiste
   MyFile = Dir(pPathFile, vbNormal)
   If Len(Trim(MyFile)) = 0 Then
      'Il file non esiste
      VerificaEsistenzaFile = False
      Call MsgInLogFile("File 'PatchUpdaterNew.exe' non trovato!")
   Else
      'Il file esiste
      VerificaEsistenzaFile = True
   End If
End Function

Private Sub VerificaEsistenzaPathCartella(pPathCartella As String, Optional pSoloControllo As Boolean, Optional prEsistenza As Boolean)
   'Questa sub serve per controllare l'esistenza di una cartella e se non esiste la crea _
    salvo che il parametro pSoloControllo non sia TRUE. In questo caso effettua SOLO il controllo. _
    L'esito dell'esistenza  passato al parametro di ritorno prEsistenza (questo l'ho fatto perch _
    non ho voluto trasformare la Sub in Funzione perch gi usata all'interno del programma)
   
   Dim MyFolder As String
   
   'restituisce una stringa vuota se la cartella non esiste
   MyFolder = Dir(pPathCartella, vbDirectory)
   If Len(Trim(MyFolder)) = 0 Then
   'crea la cartella
      If pSoloControllo = False Then MkDir pPathCartella
      prEsistenza = False
   Else
      prEsistenza = True
   End If

End Sub


Private Sub MsgInLogFile(Msg As String)  ', Optional pNomeLog As String, Optional pNuovoFile As Boolean)
   'se il parametro pNuovoFile  compilato significa che il file  diverso dallo standard

   Dim NumFile As Integer 'per aprire il file di esecuzioni(LOG)
   Dim vStrRec As String
   Dim vNomeFile As String
   
   Dim vNomeEseguibile As String
   vNomeEseguibile = App.EXEName & ".exe (rel. " & App.Major & "." & App.Minor & "." & App.Revision & ")"
   
   On Error Resume Next
   
'   If Len(pNomeLog) > 0 Then
'      vNomeFile = pNomeLog
'   Else
'      'Il file di LOG classico lo creo per Settimana in modo da non avere file troppo Grandi (se fosse stato x Mese) _
'       n troppi file nel caso avessi creato uno al giorno
'      'vNomeFile = "LogSQL_" & Year(Date) & ".sett." & gSettimanaCorrente & ".cnf"
      vNomeFile = "LogSincro_" & Year(Date) & "." & Format(Date, "mm") & ".cnf"
'   End If
      
   Call VerificaEsistenzaPathCartella(App.Path & "\Log")
   
   
'   If pNuovoFile Then
'      Call RinominaFile(App.Path & "\Log\", vNomeFile)
'   End If
   
   
   NumFile = FreeFile
      
   'Apro il file LOG
   Open App.Path & "\Log\" & vNomeFile For Append As #NumFile     'CREO IL FILE
      
      'Stampo il messaggio (la riga!)
      vStrRec = Format(Date, "yyyy/mm/dd") & "|" & _
                Format(Now, "hh:nn:ss") '& "|" & _
                pub_CodUtente
      
      vStrRec = vStrRec & "|" & Replace(Msg & " ---> by " & vNomeEseguibile, Chr(13) + Chr(10), "")
      vStrRec = vStrRec & "|"
      
      Print #NumFile, vStrRec
      '+{榦ӱ=53?+jV+uY}4A65?AGT6A ???
      
      'STRUTTURA STRINGA : _
      DATA SISTEMA | ORA SISTEMA | CODICE UTENTE | STRINGA SQL | NOME FORM DI ESECUZIONE | CARATTERE DI FINE RIGA ()
      
   'Chiudo il file di LOG
   Close #NumFile
      
   'Questa istuzione mi serve per azzerare eventuali errori che possono verificarsi. In particolarte quando il comando _
    arriva da una form Modale l'istruzione MDIForm1.ActiveForm.Name genera l'errore 91
   On Error GoTo 0
         
End Sub


Public Function GetNomeFile(PathFile As String) As String
'questa routine serve per recuperare da un path SOLO il nome del file
   Dim Pos As Byte
   
   Pos = InStrRev(PathFile, "\")
   GetNomeFile = Mid(PathFile, Pos + 1)
End Function

Public Function GetPathFile(PathFile As String) As String
'questa routine serve per recuperare da un path SOLO il Path della cartella escludendo il nome del file
   Dim Pos As Byte
   
   Pos = InStrRev(PathFile, "\")
   GetPathFile = Mid(PathFile, 1, Pos)
End Function


Public Sub KillaFile(pPathFile As String)
'QUESTA FUNZIONE PROVVEDE A CANCELLARE IL FILE PASSATO COME PARAMETRO "pPathFile"
   Dim vTentativi As Byte
 
   On Error GoTo gesterr
   
   vTentativi = 0
   
riprova:
   Kill pPathFile

   
gesterr:
   If Err.Number = 53 Then
      Resume Next
   ElseIf Err.Number <> 0 Then
      If vTentativi < 2 Then
         vTentativi = vTentativi + 1
         'Call PausaProgram(2)
         On Error GoTo 0
         GoTo riprova
      Else
         MsgBox Err.Number & " - " & Err.Description, vbCritical
      End If
   End If
   On Error GoTo 0
   
End Sub
